package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.VenvioOs2Dao;
import com.ejie.ab04b.model.VenvioOs2;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * VenvioOs2ServiceImpl generated by UDA, 26-jun-2017 10:39:48.
 * 
 * @author UDA
 */

@Service(value = "venvioOs2Service")
public class VenvioOs2ServiceImpl implements VenvioOs2Service {

	@Autowired
	private VenvioOs2Dao venvioOs2Dao;

	/**
	 * Inserts a single row in the VenvioOs2 table.
	 * 
	 *  venvioOs2
	 *            VenvioOs2
	 *  VenvioOs2
	 *
	 * @param venvioOs2 the venvio os 2
	 * @return the venvio os 2
	 */
	@Transactional(rollbackFor = Throwable.class)
	public VenvioOs2 add(VenvioOs2 venvioOs2) {
		return this.venvioOs2Dao.add(venvioOs2);
	}

	/**
	 * Updates a single row in the VenvioOs2 table.
	 * 
	 *  venvioOs2
	 *            VenvioOs2
	 *  VenvioOs2
	 *
	 * @param venvioOs2 the venvio os 2
	 * @return the venvio os 2
	 */
	@Transactional(rollbackFor = Throwable.class)
	public VenvioOs2 update(VenvioOs2 venvioOs2) {
		return this.venvioOs2Dao.update(venvioOs2);
	}

	/**
	 * Finds a single row in the VenvioOs2 table.
	 * 
	 *  venvioOs2
	 *            VenvioOs2
	 *  VenvioOs2
	 *
	 * @param venvioOs2 the venvio os 2
	 * @return the venvio os 2
	 */
	public VenvioOs2 find(VenvioOs2 venvioOs2) {
		return (VenvioOs2) this.venvioOs2Dao.find(venvioOs2);
	}

	/**
	 * Deletes a single row in the VenvioOs2 table.
	 * 
	 *  venvioOs2
	 *            VenvioOs2
	 *
	 * @param venvioOs2 the venvio os 2
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(VenvioOs2 venvioOs2) {
		this.venvioOs2Dao.remove(venvioOs2);
	}

	/**
	 * Finds a list of rows in the VenvioOs2 table.
	 * 
	 *  venvioOs2
	 *            VenvioOs2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<VenvioOs2>
	 *
	 * @param venvioOs2 the venvio os 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<VenvioOs2> findAll(VenvioOs2 venvioOs2,
			JQGridRequestDto jqGridRequestDto) {
		return (List<VenvioOs2>) this.venvioOs2Dao.findAll(venvioOs2,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the VenvioOs2 table using like.
	 * 
	 *  venvioOs2
	 *            VenvioOs2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<VenvioOs2>
	 *
	 * @param venvioOs2 the venvio os 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<VenvioOs2> findAllLike(VenvioOs2 venvioOs2,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<VenvioOs2>) this.venvioOs2Dao.findAllLike(venvioOs2,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the VenvioOs2 table.
	 * 
	 *  filterVenvioOs2
	 *            VenvioOs2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterVenvioOs2 the filter venvio os 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	public void removeMultiple(VenvioOs2 filterVenvioOs2,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.venvioOs2Dao.removeMultiple(filterVenvioOs2, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the VenvioOs2 table.
	 * 
	 *  filterVenvioOs2
	 *            VenvioOs2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<VenvioOs2>
	 *
	 * @param filterVenvioOs2 the filter venvio os 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<VenvioOs2> filter(VenvioOs2 filterVenvioOs2,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<VenvioOs2> listaVenvioOs2 = this.venvioOs2Dao.findAllLike(
				filterVenvioOs2, jqGridRequestDto, false);
		Long recordNum = this.venvioOs2Dao.findAllLikeCount(
				filterVenvioOs2 != null ? filterVenvioOs2 : new VenvioOs2(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<VenvioOs2>> reorderSelection = this.venvioOs2Dao
					.reorderSelection(filterVenvioOs2, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<VenvioOs2>(jqGridRequestDto,
					recordNum, listaVenvioOs2, reorderSelection);
		}
		return new JQGridResponseDto<VenvioOs2>(jqGridRequestDto, recordNum,
				listaVenvioOs2);
	}

	/**
	 * Searches rows in the VenvioOs2 table.
	 * 
	 *  filterVenvioOs2
	 *            VenvioOs2
	 *  searchVenvioOs2
	 *            VenvioOs2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<VenvioOs2>>
	 *
	 * @param filterVenvioOs2 the filter venvio os 2
	 * @param searchVenvioOs2 the search venvio os 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<VenvioOs2>> search(VenvioOs2 filterVenvioOs2,
			VenvioOs2 searchVenvioOs2, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.venvioOs2Dao.search(filterVenvioOs2, searchVenvioOs2,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in VenvioOs2 table.
	 * 
	 *  filterVenvioOs2
	 *            VenvioOs2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterVenvioOs2 the filter venvio os 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(VenvioOs2 filterVenvioOs2,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.venvioOs2Dao.reorderSelection(filterVenvioOs2,
				jqGridRequestDto, startsWith);
	}

}
